% Section 4.6.1 Design of FE Observer and FTC Controller
% 29/02/2020, Jianglin Lan
% This is the main file to iteratively design observer and controller gains, by automatically calling files below:
% "Baseline_controller.m", "Optimization_P1.m", "Optimization_P2.m", "Draw_figures1.m"

clear
clc
close all

% Set up Yalmip & Mosek, this may differ on different computer
% Find installation details in links: 
% https://yalmip.github.io/tutorial/installation/
% https://docs.mosek.com/9.1/toolbox/install-interface.html
addpath(genpath('C:\YALMIP-master'))
addpath('C:\Program Files\Mosek\8\toolbox\r2014a')

% System matrices
A = [    0         0    1.0000         0         0
         0   -0.1540   -0.0042    1.5400         0
         0    0.2490   -1.0000   -5.2000         0
    0.0386   -0.9960   -0.0003   -0.1170         0
         0    0.5000         0         0   -0.5000];
     
B = [    0         0
   -3.7200   -0.1600
    1.6850   -5.6000
    0.1000         0
         0         0]; 
     
F = [    0
   -3.7200
    1.6850
    0.1000
         0];
     
D = [0 0;1 1;0 1;1 0;0 0];

C = [0 1 0 0 0;0 0 0 1 1;1 1 1 0 0]; 

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% Uncertainty
Ap = [   0         0         0         0         0
         0   -0.1540   -0.0042    1.5400         0
         0    0.2490   -1.0000   -5.2000         0
    0.0386   -0.9960   -0.0003   -0.1170         0
         0    0.5000         0         0   -0.5];
Mc = eye(n);
Nc = 0.05*Ap;

% Baseline controller 
Cx = eye(n);
[K0,P0,gamma0] = Baseline_controller(A,B,D,Mc,Nc,Cx)

% Iterative design of FE and FTC gains
% Augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];

% Stop criteria
epsilon = 1.0e-5;

% Maximum iteration steps
maxJ = 100;

for j=1:maxJ
    
    j
    
    Istep(j) = j;
       
     % Solve optimization problem P1
   [gamma_hat(j),beta_hat{j},N_hat{j},G_hat{j},L_hat{j},H_hat{j},L1_hat{j},Q_hat] = Optimization_P1(A,B,F,D,C,Mc,Nc,K0,gamma0,P0); 
   beta1(j) = beta_hat{j}(1,1);
   beta2(j) = beta_hat{j}(2,2);
   beta3(j) = beta_hat{j}(3,3);
   beta4(j) = beta_hat{j}(4,4);
   beta5(j) = beta_hat{j}(5,5);
   
   % Solve optimization problem P2
   [gamma_bar(j),K_Delta{j},N_bar{j},G_bar{j},L_bar{j},H_bar{j},P_bar{j}] = Optimization_P2(A,B,F,D,C,Mc,Nc,K0,N_hat{j},G_hat{j},L_hat{j},H_hat{j},L1_hat{j},beta_hat{j},Q_hat); 
   
   if abs(gamma_bar(j)-gamma_hat(j)) < epsilon
       disp('Iteration converge:');
       Iterations = j
       K = K0 + K_Delta{j};
       N = N_bar{j};
       G = G_bar{j};
       L = L_bar{j};
       H = H_bar{j};
       
       gamma_hat_opt = gamma_hat(j)
       break;
   else
       K0 = K0 + K_Delta{j};
       P0 = P_bar{j};
       gamma0 = gamma_bar(j);
   end  
end

% Save obtained gains
save K.mat K
save N.mat N
save G.mat G
save L.mat L
save H.mat H

% Draw figures
run('Draw_figures1.m');
